/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.web.impl.OrderListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Function;
import tech.greenfield.vertx.irked.Controller;
import tech.greenfield.vertx.irked.Request;
import tech.greenfield.vertx.irked.RouteConfiguration;
import tech.greenfield.vertx.irked.Router;
import tech.greenfield.vertx.irked.exceptions.InvalidRouteConfiguration;
import tech.greenfield.vertx.irked.websocket.WebSocketMessage;

public class RouteConfigurationField
extends RouteConfiguration {
    private Field field;

    public RouteConfigurationField(Controller impl, Router router, Field f) {
        super(impl, router, f.getAnnotations());
        this.field = f;
        Type type = this.field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type rtype = pType.getActualTypeArguments()[0];
            try {
                this.trySetRoutingContextType(Class.forName(rtype.getTypeName()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    protected <T extends Annotation> T[] getAnnotation(Class<T> anot) {
        return this.field.getDeclaredAnnotationsByType(anot);
    }

    @Override
    public boolean isController() {
        return Controller.class.isAssignableFrom(this.field.getType());
    }

    @Override
    public Controller getController() {
        return this.impl.getController(this.field);
    }

    @Override
    protected String getName() {
        return this.field.getName();
    }

    @Override
    Handler<? super Request> getHandler() throws IllegalArgumentException, IllegalAccessException, InvalidRouteConfiguration {
        if (Handler.class.isAssignableFrom(this.field.getType())) {
            return this.getFieldHandler();
        }
        if (Function.class.isAssignableFrom(this.field.getType())) {
            return this.getFunctionHandler();
        }
        throw new InvalidRouteConfiguration(this + " is not a valid handler or controller");
    }

    Handler<? super Request> getFieldHandler() throws IllegalArgumentException, IllegalAccessException, InvalidRouteConfiguration {
        this.field.setAccessible(true);
        Handler handler = (Handler)this.field.get(this.impl);
        if (handler instanceof OrderListener) {
            return new FieldHandlerWithOrderListener((Handler<Request>)handler);
        }
        return new FieldHandler((Handler<Request>)handler);
    }

    Handler<? super Request> getFunctionHandler() throws IllegalArgumentException, IllegalAccessException, InvalidRouteConfiguration {
        this.field.setAccessible(true);
        Function handler = (Function)this.field.get(this.impl);
        if (handler instanceof OrderListener) {
            return new FieldHandlerWithOrderListener(handler);
        }
        return new FieldHandler(handler);
    }

    @Override
    Handler<? super WebSocketMessage> getMessageHandler() throws IllegalArgumentException, IllegalAccessException, InvalidRouteConfiguration {
        if (!Handler.class.isAssignableFrom(this.field.getType())) {
            throw new InvalidRouteConfiguration(this + " is not a valid handler");
        }
        this.field.setAccessible(true);
        final Handler handler = (Handler)this.field.get(this.impl);
        return new Handler<WebSocketMessage>(){

            public void handle(WebSocketMessage m) {
                try {
                    handler.handle((Object)m);
                }
                catch (Throwable cause) {
                    RouteConfigurationField.this.handleUserException(m, cause, "field " + RouteConfigurationField.this.field);
                }
            }

            public String toString() {
                return RouteConfigurationField.this.field.getName();
            }
        };
    }

    private class FieldHandlerWithOrderListener
    extends FieldHandler
    implements OrderListener {
        public FieldHandlerWithOrderListener(Handler<Request> handler) {
            super(handler);
        }

        public FieldHandlerWithOrderListener(Function<Request, Object> handler) {
            super(handler);
        }

        public void onOrder(int order) {
            ((OrderListener)this.handler).onOrder(order);
        }
    }

    private class FieldHandler
    implements Handler<Request> {
        protected Handler<Request> handler;

        public FieldHandler(Handler<Request> handler) {
            this.handler = handler;
        }

        public FieldHandler(Function<Request, Object> handler) {
            this.handler = r -> {
                try {
                    Object retValue = handler.apply((Request)((Object)r));
                    Future resultHandler = retValue instanceof Future ? (Future)retValue : Future.succeededFuture(retValue);
                    resultHandler.onComplete(val -> {
                        if (!r.response().headWritten()) {
                            r.sendOrFail(val);
                        }
                    });
                }
                catch (Throwable cause) {
                    r.fail(cause);
                }
            };
        }

        public void handle(Request r) {
            try {
                this.handler.handle((Object)RouteConfigurationField.this.resolveRequestContext(r));
            }
            catch (Throwable cause) {
                RouteConfigurationField.this.handleUserException(r, cause, "field " + RouteConfigurationField.this.field);
            }
        }

        public String toString() {
            return RouteConfigurationField.this.field.getName();
        }
    }
}

