/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RoutingContextDecorator;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import tech.greenfield.vertx.irked.Controller;
import tech.greenfield.vertx.irked.HttpError;
import tech.greenfield.vertx.irked.auth.AuthorizationToken;
import tech.greenfield.vertx.irked.exceptions.MissingBodyException;
import tech.greenfield.vertx.irked.helpers.JsonDecodingExceptionFormatter;
import tech.greenfield.vertx.irked.status.BadRequest;
import tech.greenfield.vertx.irked.status.HttpStatuses;

public class Request
extends RoutingContextDecorator {
    public static final String USE_JSON_PRETTY_ENCODER = "irked.json-pretty-encoder";
    private RoutingContext outerContext;
    private boolean usePrettyEncoder = false;
    private static final String SPECIFIC_FAILURE_FLD = String.format("%1$s.specific-failure", Request.class);

    private static RoutingContextInternal downCastOrFailWithExplanation(RoutingContext outerContext) {
        if (outerContext instanceof RoutingContextInternal) {
            return (RoutingContextInternal)outerContext;
        }
        throw new RuntimeException("Unexpected parent context that does not implement RoutingContextInternal! This is a bug in vertx-web 4.2.2");
    }

    public Request(RoutingContext outerContext) {
        super(outerContext.currentRoute(), Request.downCastOrFailWithExplanation(outerContext));
        this.outerContext = outerContext;
        this.usePrettyEncoder = Objects.requireNonNullElse((Boolean)this.outerContext.get(USE_JSON_PRETTY_ENCODER), this.usePrettyEncoder);
    }

    public Request setJsonEncoding(boolean usePrettyEncoder) {
        this.usePrettyEncoder = usePrettyEncoder;
        this.put(USE_JSON_PRETTY_ENCODER, this.usePrettyEncoder);
        return this;
    }

    public void next() {
        this.outerContext.next();
    }

    public <T> void next(T value) {
        this.outerContext.next();
    }

    public void fail(int statusCode) {
        this.outerContext.fail(statusCode);
    }

    public void fail(HttpError httpError) {
        this.fail(httpError.getStatusCode(), httpError);
    }

    public void fail(Throwable throwable) {
        this.outerContext.fail(Objects.requireNonNull(throwable));
    }

    public Void handleFailure(Throwable throwable) {
        Throwable failure = HttpError.unwrap(throwable);
        if (failure instanceof HttpError) {
            this.fail((HttpError)failure);
        } else {
            this.fail(failure);
        }
        return null;
    }

    public <V> V handlePossibleFailure(V successValue, Throwable throwable) {
        if (Objects.nonNull(throwable)) {
            this.fail(HttpError.unwrap(throwable));
        }
        return successValue;
    }

    public static Controller.WebHandler failureHandler() {
        return r -> {
            if (r.response().ended() || !r.failed()) {
                r.next();
            } else {
                r.sendError(HttpError.toHttpError((RoutingContext)r));
            }
        };
    }

    public <T> T getBodyAs(Class<T> type) {
        String contentType = this.request().getHeader("Content-Type");
        if (Objects.isNull(contentType)) {
            contentType = "application/json";
        }
        String[] ctParts = contentType.split(";\\s*");
        switch (ctParts[0]) {
            case "application/x-www-form-urlencoded": {
                JsonObject out = new JsonObject();
                this.request().formAttributes().forEach(e -> {
                    Object old = out.getValue((String)e.getKey());
                    if (Objects.isNull(old)) {
                        out.put((String)e.getKey(), e.getValue());
                        return;
                    }
                    if (old instanceof JsonArray) {
                        ((JsonArray)old).add(e.getValue());
                        return;
                    }
                    out.put((String)e.getKey(), (Object)new JsonArray().add(old).add(e.getValue()));
                });
                return (T)out.mapTo(type);
            }
        }
        try {
            Object body = this.body().asPojo(type);
            if (body == null) {
                throw new MissingBodyException().unchecked();
            }
            return (T)body;
        }
        catch (DecodeException e2) {
            throw new BadRequest(JsonDecodingExceptionFormatter.formatFriendlyErrorMessage(e2), e2).unchecked();
        }
    }

    public Future<Void> sendJSON(JsonObject json) {
        return this.sendJSON(json, this.statusFromResponseCode());
    }

    public Future<Void> sendObject(Object data) {
        try {
            return this.sendJSON(JsonObject.mapFrom((Object)data));
        }
        catch (Throwable t) {
            return Future.failedFuture((Throwable)t);
        }
    }

    public Future<Void> sendJSON(JsonArray json) {
        return this.sendJSON(json, this.statusFromResponseCode());
    }

    public Future<Void> sendJSON(JsonObject json, HttpError status) {
        return this.sendContent(Json.CODEC.toString((Object)json, this.usePrettyEncoder), status, "application/json");
    }

    public Future<Void> sendObject(Object data, HttpError status) {
        try {
            return this.sendJSON(JsonObject.mapFrom((Object)data), status);
        }
        catch (Throwable t) {
            return Future.failedFuture((Throwable)t);
        }
    }

    public Future<Void> sendJSON(JsonArray json, HttpError status) {
        return this.sendContent(Json.CODEC.toString((Object)json, this.usePrettyEncoder), status, "application/json");
    }

    public Future<Void> sendContent(String content, HttpError status, String contentType) {
        return this.sendContent(Buffer.buffer((String)content), status, contentType);
    }

    public Future<Void> sendContent(Buffer content, HttpError status, String contentType) {
        HttpServerResponse res = this.response(status).putHeader("Content-Type", contentType).putHeader("Content-Length", String.valueOf(content.length()));
        if (this.isHead()) {
            return res.end();
        }
        return res.end(content);
    }

    public Future<Void> sendContent(String content, String contentType) {
        return this.sendContent(content, this.statusFromResponseCode(), contentType);
    }

    public Future<Void> sendContent(String content, HttpError status) {
        return this.sendContent(content, status, "text/plain");
    }

    public Future<Void> sendContent(String content) {
        return this.sendContent(content, this.statusFromResponseCode(), "text/plain");
    }

    public Future<Void> sendError(HttpError status) {
        return this.sendJSON(new JsonObject().put("status", (Object)(status.getStatusCode() / 100 == 2 ? 1 : 0)).put("message", (Object)status.getMessage()), status);
    }

    public Future<Void> send(JsonObject object) {
        return this.sendJSON(object);
    }

    public Future<Void> send(JsonArray list) {
        return this.sendJSON(list);
    }

    public Future<Void> send(String content) {
        return this.sendContent(content);
    }

    public Future<Void> send(Buffer buffer) {
        return this.sendContent(buffer, this.statusFromResponseCode(), "application/octet-stream");
    }

    public Future<Void> send(HttpError status) {
        return this.sendError(status);
    }

    public <G> Future<Void> sendList(List<G> list) {
        return this.sendStream(list.stream());
    }

    public <G> Future<Void> sendStream(Stream<G> stream) {
        try {
            return this.sendJSON(stream.map(this::encodeToJsonType).collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
        }
        catch (Throwable t) {
            return Future.failedFuture((Throwable)t);
        }
    }

    public Future<Void> send(Object object) {
        if (object instanceof Collection) {
            return this.sendStream(((Collection)object).stream());
        }
        if (object instanceof Stream) {
            return this.sendStream((Stream)object);
        }
        if (object instanceof Throwable) {
            return this.sendError(HttpError.toHttpError((Throwable)object));
        }
        if (object instanceof JsonObject) {
            return this.sendJSON((JsonObject)object);
        }
        if (object instanceof JsonArray) {
            return this.sendJSON((JsonArray)object);
        }
        if (object instanceof String) {
            return this.sendContent((String)object);
        }
        return this.sendObject(object);
    }

    public <T> Future<Void> sendOrFail(AsyncResult<T> result) {
        if (result.failed()) {
            this.handleFailure(result.cause());
            return Future.failedFuture((Throwable)result.cause());
        }
        return this.send(result.result()).onFailure(this::handleFailure);
    }

    public HttpServerResponse response(HttpError status) {
        HttpServerResponse res = this.response();
        for (Map.Entry h : status.getHeaders()) {
            res.putHeader((String)h.getKey(), (String)h.getValue());
        }
        return res.setStatusCode(status.getStatusCode()).setStatusMessage(status.getStatusText());
    }

    public boolean needUpgrade() {
        return this.needUpgrade(null);
    }

    public boolean needUpgrade(String type) {
        HttpServerRequest req = this.request();
        return req.getHeader("Connection").equalsIgnoreCase("upgrade") && (Objects.isNull(type) || req.getHeader("Upgrade").equalsIgnoreCase(type));
    }

    public AuthorizationToken getAuthorization() {
        return AuthorizationToken.parse(this.request().getHeader("Authorization"));
    }

    private Object encodeToJsonType(Object value) {
        if (value instanceof Boolean || value instanceof Number || value instanceof String || value instanceof JsonArray || value instanceof List || value instanceof JsonObject || value instanceof Map) {
            return value;
        }
        return JsonObject.mapFrom((Object)value);
    }

    public boolean isHead() {
        return this.request().method() == HttpMethod.HEAD;
    }

    public <G extends Throwable> G findFailure(Class<G> failureType) {
        if (!this.failed()) {
            return null;
        }
        Throwable specificFailure = (Throwable)this.get(SPECIFIC_FAILURE_FLD);
        if (failureType.isInstance(specificFailure)) {
            Throwable actual = specificFailure;
            return (G)actual;
        }
        for (Throwable f = this.failure(); f != null; f = f.getCause()) {
            if (!failureType.isInstance(f)) continue;
            Throwable actual = f;
            return (G)actual;
        }
        return null;
    }

    public Request setSpecificFailure(Throwable failure) {
        if (this.failed()) {
            this.put(SPECIFIC_FAILURE_FLD, failure);
        }
        return this;
    }

    public HttpError statusFromResponseCode() {
        return this.statusFromResponseCode(this.response().getStatusCode(), this.response().getStatusMessage());
    }

    public HttpError statusFromResponseCode(int statusCode) {
        return this.statusFromResponseCode(statusCode, HttpResponseStatus.valueOf((int)statusCode).reasonPhrase());
    }

    public HttpError statusFromResponseCode(int statusCode, String statusMessage) {
        try {
            return HttpStatuses.create(statusCode).setStatusText(statusMessage);
        }
        catch (InstantiationException e) {
            return new HttpError(statusCode, statusMessage);
        }
    }
}

