package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Unsupported Media Type
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class UnsupportedMediaType extends HttpError {

private static final long serialVersionUID = -8321332997068727248L;

/** HTTP status code for 'Unsupported Media Type' */
public static final int code = 415;

/** Create a 'Unsupported Media Type' HTTP Response. */
public UnsupportedMediaType() {
super(415,"Unsupported Media Type");
}

/** Create a 'Unsupported Media Type' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public UnsupportedMediaType(Throwable t) {
super(415,"Unsupported Media Type", t);
}

/** Create a 'Unsupported Media Type' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public UnsupportedMediaType(String m) {
super(415,"Unsupported Media Type", m);
}

/** Create a 'Unsupported Media Type' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public UnsupportedMediaType(String m, Throwable t) {
super(415,"Unsupported Media Type", m, t);
}

}
