package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Unauthorized
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class Unauthorized extends HttpError {

private static final long serialVersionUID = -6069550943747302382L;

/** HTTP status code for 'Unauthorized' */
public static final int code = 401;

/** Create a 'Unauthorized' HTTP Response. */
public Unauthorized() {
super(401,"Unauthorized");
}

/** Create a 'Unauthorized' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public Unauthorized(Throwable t) {
super(401,"Unauthorized", t);
}

/** Create a 'Unauthorized' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public Unauthorized(String m) {
super(401,"Unauthorized", m);
}

/** Create a 'Unauthorized' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public Unauthorized(String m, Throwable t) {
super(401,"Unauthorized", m, t);
}

}
