package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Temporary Redirect
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class TemporaryRedirect extends HttpError {

private static final long serialVersionUID = 1655725832875911273L;

/** HTTP status code for 'Temporary Redirect' */
public static final int code = 307;

/** Create a 'Temporary Redirect' HTTP Response. */
public TemporaryRedirect() {
super(307,"Temporary Redirect");
}

/** Create a 'Temporary Redirect' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public TemporaryRedirect(Throwable t) {
super(307,"Temporary Redirect", t);
}

/** Create a 'Temporary Redirect' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public TemporaryRedirect(String m) {
super(307,"Temporary Redirect", m);
}

/** Create a 'Temporary Redirect' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public TemporaryRedirect(String m, Throwable t) {
super(307,"Temporary Redirect", m, t);
}

}
