package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Service Unavailable
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class ServiceUnavailable extends HttpError {

private static final long serialVersionUID = 1062266826675786184L;

/** HTTP status code for 'Service Unavailable' */
public static final int code = 503;

/** Create a 'Service Unavailable' HTTP Response. */
public ServiceUnavailable() {
super(503,"Service Unavailable");
}

/** Create a 'Service Unavailable' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public ServiceUnavailable(Throwable t) {
super(503,"Service Unavailable", t);
}

/** Create a 'Service Unavailable' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public ServiceUnavailable(String m) {
super(503,"Service Unavailable", m);
}

/** Create a 'Service Unavailable' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public ServiceUnavailable(String m, Throwable t) {
super(503,"Service Unavailable", m, t);
}

}
