package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Request Timeout
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class RequestTimeout extends HttpError {

private static final long serialVersionUID = -8251973910236717544L;

/** HTTP status code for 'Request Timeout' */
public static final int code = 408;

/** Create a 'Request Timeout' HTTP Response. */
public RequestTimeout() {
super(408,"Request Timeout");
}

/** Create a 'Request Timeout' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public RequestTimeout(Throwable t) {
super(408,"Request Timeout", t);
}

/** Create a 'Request Timeout' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public RequestTimeout(String m) {
super(408,"Request Timeout", m);
}

/** Create a 'Request Timeout' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public RequestTimeout(String m, Throwable t) {
super(408,"Request Timeout", m, t);
}

}
