package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Processing
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class Processing extends HttpError {

private static final long serialVersionUID = -2451209203709334095L;

/** HTTP status code for 'Processing' */
public static final int code = 102;

/** Create a 'Processing' HTTP Response. */
public Processing() {
super(102,"Processing");
}

/** Create a 'Processing' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public Processing(Throwable t) {
super(102,"Processing", t);
}

/** Create a 'Processing' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public Processing(String m) {
super(102,"Processing", m);
}

/** Create a 'Processing' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public Processing(String m, Throwable t) {
super(102,"Processing", m, t);
}

}
