package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Precondition Required
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class PreconditionRequired extends HttpError {

private static final long serialVersionUID = -6038846880559142776L;

/** HTTP status code for 'Precondition Required' */
public static final int code = 428;

/** Create a 'Precondition Required' HTTP Response. */
public PreconditionRequired() {
super(428,"Precondition Required");
}

/** Create a 'Precondition Required' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public PreconditionRequired(Throwable t) {
super(428,"Precondition Required", t);
}

/** Create a 'Precondition Required' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public PreconditionRequired(String m) {
super(428,"Precondition Required", m);
}

/** Create a 'Precondition Required' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public PreconditionRequired(String m, Throwable t) {
super(428,"Precondition Required", m, t);
}

}
