package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Precondition Failed
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class PreconditionFailed extends HttpError {

private static final long serialVersionUID = 8436025471322039701L;

/** HTTP status code for 'Precondition Failed' */
public static final int code = 412;

/** Create a 'Precondition Failed' HTTP Response. */
public PreconditionFailed() {
super(412,"Precondition Failed");
}

/** Create a 'Precondition Failed' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public PreconditionFailed(Throwable t) {
super(412,"Precondition Failed", t);
}

/** Create a 'Precondition Failed' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public PreconditionFailed(String m) {
super(412,"Precondition Failed", m);
}

/** Create a 'Precondition Failed' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public PreconditionFailed(String m, Throwable t) {
super(412,"Precondition Failed", m, t);
}

}
