package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Permanent Redirect
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class PermanentRedirect extends HttpError {

private static final long serialVersionUID = 2683265807765126570L;

/** HTTP status code for 'Permanent Redirect' */
public static final int code = 308;

/** Create a 'Permanent Redirect' HTTP Response. */
public PermanentRedirect() {
super(308,"Permanent Redirect");
}

/** Create a 'Permanent Redirect' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public PermanentRedirect(Throwable t) {
super(308,"Permanent Redirect", t);
}

/** Create a 'Permanent Redirect' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public PermanentRedirect(String m) {
super(308,"Permanent Redirect", m);
}

/** Create a 'Permanent Redirect' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public PermanentRedirect(String m, Throwable t) {
super(308,"Permanent Redirect", m, t);
}

}
