package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Payment Required
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class PaymentRequired extends HttpError {

private static final long serialVersionUID = -5091522252779109793L;

/** HTTP status code for 'Payment Required' */
public static final int code = 402;

/** Create a 'Payment Required' HTTP Response. */
public PaymentRequired() {
super(402,"Payment Required");
}

/** Create a 'Payment Required' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public PaymentRequired(Throwable t) {
super(402,"Payment Required", t);
}

/** Create a 'Payment Required' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public PaymentRequired(String m) {
super(402,"Payment Required", m);
}

/** Create a 'Payment Required' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public PaymentRequired(String m, Throwable t) {
super(402,"Payment Required", m, t);
}

}
