package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Payload Too Large
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class PayloadTooLarge extends HttpError {

private static final long serialVersionUID = -1323306397726662677L;

/** HTTP status code for 'Payload Too Large' */
public static final int code = 413;

/** Create a 'Payload Too Large' HTTP Response. */
public PayloadTooLarge() {
super(413,"Payload Too Large");
}

/** Create a 'Payload Too Large' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public PayloadTooLarge(Throwable t) {
super(413,"Payload Too Large", t);
}

/** Create a 'Payload Too Large' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public PayloadTooLarge(String m) {
super(413,"Payload Too Large", m);
}

/** Create a 'Payload Too Large' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public PayloadTooLarge(String m, Throwable t) {
super(413,"Payload Too Large", m, t);
}

}
