package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for OK
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class OK extends HttpError {

private static final long serialVersionUID = -3076197743546731333L;

/** HTTP status code for 'OK' */
public static final int code = 200;

/** Create a 'OK' HTTP Response. */
public OK() {
super(200,"OK");
}

/** Create a 'OK' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public OK(Throwable t) {
super(200,"OK", t);
}

/** Create a 'OK' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public OK(String m) {
super(200,"OK", m);
}

/** Create a 'OK' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public OK(String m, Throwable t) {
super(200,"OK", m, t);
}

}
