package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Not Modified
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class NotModified extends HttpError {

private static final long serialVersionUID = -978058102395388367L;

/** HTTP status code for 'Not Modified' */
public static final int code = 304;

/** Create a 'Not Modified' HTTP Response. */
public NotModified() {
super(304,"Not Modified");
}

/** Create a 'Not Modified' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public NotModified(Throwable t) {
super(304,"Not Modified", t);
}

/** Create a 'Not Modified' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public NotModified(String m) {
super(304,"Not Modified", m);
}

/** Create a 'Not Modified' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public NotModified(String m, Throwable t) {
super(304,"Not Modified", m, t);
}

}
