package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Not Implemented
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class NotImplemented extends HttpError {

private static final long serialVersionUID = 515775094249230929L;

/** HTTP status code for 'Not Implemented' */
public static final int code = 501;

/** Create a 'Not Implemented' HTTP Response. */
public NotImplemented() {
super(501,"Not Implemented");
}

/** Create a 'Not Implemented' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public NotImplemented(Throwable t) {
super(501,"Not Implemented", t);
}

/** Create a 'Not Implemented' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public NotImplemented(String m) {
super(501,"Not Implemented", m);
}

/** Create a 'Not Implemented' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public NotImplemented(String m, Throwable t) {
super(501,"Not Implemented", m, t);
}

}
