package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Not Acceptable
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class NotAcceptable extends HttpError {

private static final long serialVersionUID = 3573601277777883364L;

/** HTTP status code for 'Not Acceptable' */
public static final int code = 406;

/** Create a 'Not Acceptable' HTTP Response. */
public NotAcceptable() {
super(406,"Not Acceptable");
}

/** Create a 'Not Acceptable' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public NotAcceptable(Throwable t) {
super(406,"Not Acceptable", t);
}

/** Create a 'Not Acceptable' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public NotAcceptable(String m) {
super(406,"Not Acceptable", m);
}

/** Create a 'Not Acceptable' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public NotAcceptable(String m, Throwable t) {
super(406,"Not Acceptable", m, t);
}

}
