package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Insufficient Storage
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class InsufficientStorage extends HttpError {

private static final long serialVersionUID = 7518509656998604812L;

/** HTTP status code for 'Insufficient Storage' */
public static final int code = 507;

/** Create a 'Insufficient Storage' HTTP Response. */
public InsufficientStorage() {
super(507,"Insufficient Storage");
}

/** Create a 'Insufficient Storage' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public InsufficientStorage(Throwable t) {
super(507,"Insufficient Storage", t);
}

/** Create a 'Insufficient Storage' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public InsufficientStorage(String m) {
super(507,"Insufficient Storage", m);
}

/** Create a 'Insufficient Storage' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public InsufficientStorage(String m, Throwable t) {
super(507,"Insufficient Storage", m, t);
}

}
