package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for I'm a teapot
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class Imateapot extends HttpError {

private static final long serialVersionUID = -3402889348087080914L;

/** HTTP status code for 'I'm a teapot' */
public static final int code = 418;

/** Create a 'I'm a teapot' HTTP Response. */
public Imateapot() {
super(418,"I'm a teapot");
}

/** Create a 'I'm a teapot' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public Imateapot(Throwable t) {
super(418,"I'm a teapot", t);
}

/** Create a 'I'm a teapot' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public Imateapot(String m) {
super(418,"I'm a teapot", m);
}

/** Create a 'I'm a teapot' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public Imateapot(String m, Throwable t) {
super(418,"I'm a teapot", m, t);
}

}
