package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Gone
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class Gone extends HttpError {

private static final long serialVersionUID = -951011768704495128L;

/** HTTP status code for 'Gone' */
public static final int code = 410;

/** Create a 'Gone' HTTP Response. */
public Gone() {
super(410,"Gone");
}

/** Create a 'Gone' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public Gone(Throwable t) {
super(410,"Gone", t);
}

/** Create a 'Gone' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public Gone(String m) {
super(410,"Gone", m);
}

/** Create a 'Gone' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public Gone(String m, Throwable t) {
super(410,"Gone", m, t);
}

}
