package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Found
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class Found extends HttpError {

private static final long serialVersionUID = -5782527879806400194L;

/** HTTP status code for 'Found' */
public static final int code = 302;

/** Create a 'Found' HTTP Response. */
public Found() {
super(302,"Found");
}

/** Create a 'Found' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public Found(Throwable t) {
super(302,"Found", t);
}

/** Create a 'Found' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public Found(String m) {
super(302,"Found", m);
}

/** Create a 'Found' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public Found(String m, Throwable t) {
super(302,"Found", m, t);
}

}
