package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Forbidden
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class Forbidden extends HttpError {

private static final long serialVersionUID = 7514092612054329029L;

/** HTTP status code for 'Forbidden' */
public static final int code = 403;

/** Create a 'Forbidden' HTTP Response. */
public Forbidden() {
super(403,"Forbidden");
}

/** Create a 'Forbidden' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public Forbidden(Throwable t) {
super(403,"Forbidden", t);
}

/** Create a 'Forbidden' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public Forbidden(String m) {
super(403,"Forbidden", m);
}

/** Create a 'Forbidden' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public Forbidden(String m, Throwable t) {
super(403,"Forbidden", m, t);
}

}
