package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Failed Dependency
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class FailedDependency extends HttpError {

private static final long serialVersionUID = -8185187958722932137L;

/** HTTP status code for 'Failed Dependency' */
public static final int code = 424;

/** Create a 'Failed Dependency' HTTP Response. */
public FailedDependency() {
super(424,"Failed Dependency");
}

/** Create a 'Failed Dependency' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public FailedDependency(Throwable t) {
super(424,"Failed Dependency", t);
}

/** Create a 'Failed Dependency' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public FailedDependency(String m) {
super(424,"Failed Dependency", m);
}

/** Create a 'Failed Dependency' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public FailedDependency(String m, Throwable t) {
super(424,"Failed Dependency", m, t);
}

}
