package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Expectation Failed
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class ExpectationFailed extends HttpError {

private static final long serialVersionUID = -5247869490719750318L;

/** HTTP status code for 'Expectation Failed' */
public static final int code = 417;

/** Create a 'Expectation Failed' HTTP Response. */
public ExpectationFailed() {
super(417,"Expectation Failed");
}

/** Create a 'Expectation Failed' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public ExpectationFailed(Throwable t) {
super(417,"Expectation Failed", t);
}

/** Create a 'Expectation Failed' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public ExpectationFailed(String m) {
super(417,"Expectation Failed", m);
}

/** Create a 'Expectation Failed' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public ExpectationFailed(String m, Throwable t) {
super(417,"Expectation Failed", m, t);
}

}
