package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Bad Gateway
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class BadGateway extends HttpError {

private static final long serialVersionUID = 7979752048567679187L;

/** HTTP status code for 'Bad Gateway' */
public static final int code = 502;

/** Create a 'Bad Gateway' HTTP Response. */
public BadGateway() {
super(502,"Bad Gateway");
}

/** Create a 'Bad Gateway' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public BadGateway(Throwable t) {
super(502,"Bad Gateway", t);
}

/** Create a 'Bad Gateway' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public BadGateway(String m) {
super(502,"Bad Gateway", m);
}

/** Create a 'Bad Gateway' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public BadGateway(String m, Throwable t) {
super(502,"Bad Gateway", m, t);
}

}
