/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked.websocket;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import tech.greenfield.vertx.irked.Request;

public class WebSocketMessage
implements Buffer {
    private Buffer buffer;
    private Request request;
    private ServerWebSocket socket;
    boolean isBinary;

    public WebSocketMessage(Request request, ServerWebSocket socket, Buffer buffer) {
        this.request = request;
        this.socket = socket;
        this.buffer = buffer;
        this.isBinary = true;
    }

    public WebSocketMessage(Request request, ServerWebSocket socket, String text) {
        this.request = request;
        this.socket = socket;
        this.buffer = Buffer.buffer((String)text);
        this.isBinary = false;
    }

    public Request request() {
        return this.request;
    }

    public ServerWebSocket socket() {
        return this.socket;
    }

    public void reply(String text) {
        this.socket.writeTextMessage(text);
    }

    public void reply(Buffer buffer) {
        this.socket.writeBinaryMessage(buffer);
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public void writeToBuffer(Buffer buffer) {
        buffer.writeToBuffer(buffer);
    }

    public int readFromBuffer(int pos, Buffer buffer) {
        return buffer.readFromBuffer(pos, buffer);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public String toString(String enc) {
        return this.buffer.toString(enc);
    }

    public String toString(Charset enc) {
        return this.buffer.toString(enc);
    }

    public JsonObject toJsonObject() {
        return this.buffer.toJsonObject();
    }

    public JsonArray toJsonArray() {
        return this.buffer.toJsonArray();
    }

    public byte getByte(int pos) {
        return this.buffer.getByte(pos);
    }

    public short getUnsignedByte(int pos) {
        return this.buffer.getUnsignedByte(pos);
    }

    public int getInt(int pos) {
        return this.buffer.getInt(pos);
    }

    public int getIntLE(int pos) {
        return this.buffer.getIntLE(pos);
    }

    public long getUnsignedInt(int pos) {
        return this.buffer.getUnsignedInt(pos);
    }

    public long getUnsignedIntLE(int pos) {
        return this.buffer.getUnsignedIntLE(pos);
    }

    public long getLong(int pos) {
        return this.buffer.getLong(pos);
    }

    public long getLongLE(int pos) {
        return this.buffer.getLongLE(pos);
    }

    public double getDouble(int pos) {
        return this.buffer.getDouble(pos);
    }

    public float getFloat(int pos) {
        return this.buffer.getFloat(pos);
    }

    public short getShort(int pos) {
        return this.buffer.getShort(pos);
    }

    public short getShortLE(int pos) {
        return this.buffer.getShortLE(pos);
    }

    public int getUnsignedShort(int pos) {
        return this.buffer.getUnsignedShort(pos);
    }

    public int getUnsignedShortLE(int pos) {
        return this.buffer.getUnsignedShortLE(pos);
    }

    public int getMedium(int pos) {
        return this.buffer.getMedium(pos);
    }

    public int getMediumLE(int pos) {
        return this.buffer.getMediumLE(pos);
    }

    public int getUnsignedMedium(int pos) {
        return this.buffer.getUnsignedMedium(pos);
    }

    public int getUnsignedMediumLE(int pos) {
        return this.buffer.getUnsignedMediumLE(pos);
    }

    public byte[] getBytes() {
        return this.buffer.getBytes();
    }

    public byte[] getBytes(int start, int end) {
        return this.buffer.getBytes(start, end);
    }

    public Buffer getBytes(byte[] dst) {
        this.buffer.getBytes(dst);
        return this;
    }

    public Buffer getBytes(byte[] dst, int dstIndex) {
        this.buffer.getBytes(dst, dstIndex);
        return this;
    }

    public Buffer getBytes(int start, int end, byte[] dst) {
        this.buffer.getBytes(start, end, dst);
        return this;
    }

    public Buffer getBytes(int start, int end, byte[] dst, int dstIndex) {
        this.buffer.getBytes(start, end, dst, dstIndex);
        return this;
    }

    public Buffer getBuffer(int start, int end) {
        return this.buffer.getBuffer(start, end);
    }

    public String getString(int start, int end, String enc) {
        return this.buffer.getString(start, end, enc);
    }

    public String getString(int start, int end) {
        return this.buffer.getString(start, end);
    }

    public Buffer appendBuffer(Buffer buff) {
        this.buffer.appendBuffer(buff);
        return this;
    }

    public Buffer appendBuffer(Buffer buff, int offset, int len) {
        this.buffer.appendBuffer(buff, offset, len);
        return this;
    }

    public Buffer appendBytes(byte[] bytes) {
        this.buffer.appendBytes(bytes);
        return this;
    }

    public Buffer appendBytes(byte[] bytes, int offset, int len) {
        this.buffer.appendBytes(bytes, offset, len);
        return this;
    }

    public Buffer appendByte(byte b) {
        this.buffer.appendByte(b);
        return this;
    }

    public Buffer appendUnsignedByte(short b) {
        this.buffer.appendUnsignedByte(b);
        return this;
    }

    public Buffer appendInt(int i) {
        this.buffer.appendInt(i);
        return this;
    }

    public Buffer appendIntLE(int i) {
        this.buffer.appendIntLE(i);
        return this;
    }

    public Buffer appendUnsignedInt(long i) {
        this.buffer.appendUnsignedInt(i);
        return this;
    }

    public Buffer appendUnsignedIntLE(long i) {
        this.buffer.appendUnsignedIntLE(i);
        return this;
    }

    public Buffer appendMedium(int i) {
        this.buffer.appendMedium(i);
        return this;
    }

    public Buffer appendMediumLE(int i) {
        this.buffer.appendMediumLE(i);
        return this;
    }

    public Buffer appendLong(long l) {
        this.buffer.appendLong(l);
        return this;
    }

    public Buffer appendLongLE(long l) {
        this.buffer.appendLongLE(l);
        return this;
    }

    public Buffer appendShort(short s) {
        this.buffer.appendShort(s);
        return this;
    }

    public Buffer appendShortLE(short s) {
        this.buffer.appendShortLE(s);
        return this;
    }

    public Buffer appendUnsignedShort(int s) {
        this.buffer.appendUnsignedShort(s);
        return this;
    }

    public Buffer appendUnsignedShortLE(int s) {
        this.buffer.appendUnsignedShortLE(s);
        return this;
    }

    public Buffer appendFloat(float f) {
        this.buffer.appendFloat(f);
        return this;
    }

    public Buffer appendDouble(double d) {
        this.buffer.appendDouble(d);
        return this;
    }

    public Buffer appendString(String str, String enc) {
        this.buffer.appendString(str, enc);
        return this;
    }

    public Buffer appendString(String str) {
        this.buffer.appendString(str);
        return this;
    }

    public Buffer setByte(int pos, byte b) {
        this.buffer.setByte(pos, b);
        return this;
    }

    public Buffer setUnsignedByte(int pos, short b) {
        this.buffer.setUnsignedByte(pos, b);
        return this;
    }

    public Buffer setInt(int pos, int i) {
        this.buffer.setInt(pos, i);
        return this;
    }

    public Buffer setIntLE(int pos, int i) {
        this.buffer.setIntLE(pos, i);
        return this;
    }

    public Buffer setUnsignedInt(int pos, long i) {
        this.buffer.setUnsignedInt(pos, i);
        return this;
    }

    public Buffer setUnsignedIntLE(int pos, long i) {
        this.buffer.setUnsignedIntLE(pos, i);
        return this;
    }

    public Buffer setMedium(int pos, int i) {
        this.buffer.setMedium(pos, i);
        return this;
    }

    public Buffer setMediumLE(int pos, int i) {
        this.buffer.setMediumLE(pos, i);
        return this;
    }

    public Buffer setLong(int pos, long l) {
        this.buffer.setLong(pos, l);
        return this;
    }

    public Buffer setLongLE(int pos, long l) {
        this.buffer.setLongLE(pos, l);
        return this;
    }

    public Buffer setDouble(int pos, double d) {
        this.buffer.setDouble(pos, d);
        return this;
    }

    public Buffer setFloat(int pos, float f) {
        this.buffer.setFloat(pos, f);
        return this;
    }

    public Buffer setShort(int pos, short s) {
        this.buffer.setShort(pos, s);
        return this;
    }

    public Buffer setShortLE(int pos, short s) {
        this.buffer.setShortLE(pos, s);
        return this;
    }

    public Buffer setUnsignedShort(int pos, int s) {
        this.buffer.setUnsignedShort(pos, s);
        return this;
    }

    public Buffer setUnsignedShortLE(int pos, int s) {
        this.buffer.setUnsignedShortLE(pos, s);
        return this;
    }

    public Buffer setBuffer(int pos, Buffer b) {
        this.buffer.setBuffer(pos, b);
        return this;
    }

    public Buffer setBuffer(int pos, Buffer b, int offset, int len) {
        this.buffer.setBuffer(pos, b, offset, len);
        return this;
    }

    public Buffer setBytes(int pos, ByteBuffer b) {
        this.buffer.setBytes(pos, b);
        return this;
    }

    public Buffer setBytes(int pos, byte[] b) {
        this.buffer.setBytes(pos, b);
        return this;
    }

    public Buffer setBytes(int pos, byte[] b, int offset, int len) {
        this.buffer.setBytes(pos, b, offset, len);
        return this;
    }

    public Buffer setString(int pos, String str) {
        this.buffer.setString(pos, str);
        return this;
    }

    public Buffer setString(int pos, String str, String enc) {
        this.buffer.setString(pos, str, enc);
        return this;
    }

    public int length() {
        return this.buffer.length();
    }

    public Buffer copy() {
        return this.buffer.copy();
    }

    public Buffer slice() {
        return this.buffer.slice();
    }

    public Buffer slice(int start, int end) {
        return this.buffer.slice(start, end);
    }

    @Deprecated
    public ByteBuf getByteBuf() {
        return this.buffer.getByteBuf();
    }
}

