/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked.status;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.TreeMap;
import tech.greenfield.vertx.irked.HttpError;
import tech.greenfield.vertx.irked.status.Accepted;
import tech.greenfield.vertx.irked.status.BadGateway;
import tech.greenfield.vertx.irked.status.BadRequest;
import tech.greenfield.vertx.irked.status.Conflict;
import tech.greenfield.vertx.irked.status.Continue;
import tech.greenfield.vertx.irked.status.Created;
import tech.greenfield.vertx.irked.status.ExpectationFailed;
import tech.greenfield.vertx.irked.status.FailedDependency;
import tech.greenfield.vertx.irked.status.Forbidden;
import tech.greenfield.vertx.irked.status.Found;
import tech.greenfield.vertx.irked.status.GatewayTimeout;
import tech.greenfield.vertx.irked.status.Gone;
import tech.greenfield.vertx.irked.status.HTTPVersionNotSupported;
import tech.greenfield.vertx.irked.status.IMUsed;
import tech.greenfield.vertx.irked.status.Imateapot;
import tech.greenfield.vertx.irked.status.InsufficientStorage;
import tech.greenfield.vertx.irked.status.InternalServerError;
import tech.greenfield.vertx.irked.status.LengthRequired;
import tech.greenfield.vertx.irked.status.Locked;
import tech.greenfield.vertx.irked.status.MethodNotAllowed;
import tech.greenfield.vertx.irked.status.MovedPermanently;
import tech.greenfield.vertx.irked.status.MultiStatus;
import tech.greenfield.vertx.irked.status.MultipleChoices;
import tech.greenfield.vertx.irked.status.NetworkAuthenticationRequired;
import tech.greenfield.vertx.irked.status.NoContent;
import tech.greenfield.vertx.irked.status.NonAuthoritativeInformation;
import tech.greenfield.vertx.irked.status.NotAcceptable;
import tech.greenfield.vertx.irked.status.NotFound;
import tech.greenfield.vertx.irked.status.NotImplemented;
import tech.greenfield.vertx.irked.status.NotModified;
import tech.greenfield.vertx.irked.status.OK;
import tech.greenfield.vertx.irked.status.PartialContent;
import tech.greenfield.vertx.irked.status.PayloadTooLarge;
import tech.greenfield.vertx.irked.status.PaymentRequired;
import tech.greenfield.vertx.irked.status.PermanentRedirect;
import tech.greenfield.vertx.irked.status.PreconditionFailed;
import tech.greenfield.vertx.irked.status.PreconditionRequired;
import tech.greenfield.vertx.irked.status.Processing;
import tech.greenfield.vertx.irked.status.ProxyAuthenticationRequired;
import tech.greenfield.vertx.irked.status.RangeNotSatisfiable;
import tech.greenfield.vertx.irked.status.RequestHeaderFieldsTooLarge;
import tech.greenfield.vertx.irked.status.RequestTimeout;
import tech.greenfield.vertx.irked.status.ResetContent;
import tech.greenfield.vertx.irked.status.SeeOther;
import tech.greenfield.vertx.irked.status.ServiceUnavailable;
import tech.greenfield.vertx.irked.status.SwitchingProtocols;
import tech.greenfield.vertx.irked.status.TemporaryRedirect;
import tech.greenfield.vertx.irked.status.TooManyRequests;
import tech.greenfield.vertx.irked.status.URITooLong;
import tech.greenfield.vertx.irked.status.Unauthorized;
import tech.greenfield.vertx.irked.status.UnavailableForLegalReasons;
import tech.greenfield.vertx.irked.status.UnprocessableEntity;
import tech.greenfield.vertx.irked.status.UnsupportedMediaType;
import tech.greenfield.vertx.irked.status.UpgradeRequired;
import tech.greenfield.vertx.irked.status.UseProxy;
import tech.greenfield.vertx.irked.status.VariantAlsoNegotiates;

public class HttpStatuses {
    public static Map<Integer, Class<? extends HttpError>> HTTP_STATUS_CODES = new TreeMap<Integer, Class<? extends HttpError>>();

    public static HttpError create(int statusCode) throws InstantiationException {
        try {
            return HTTP_STATUS_CODES.get(statusCode).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InstantiationException(e.toString());
        }
    }

    static {
        HTTP_STATUS_CODES.put(100, Continue.class);
        HTTP_STATUS_CODES.put(101, SwitchingProtocols.class);
        HTTP_STATUS_CODES.put(102, Processing.class);
        HTTP_STATUS_CODES.put(200, OK.class);
        HTTP_STATUS_CODES.put(201, Created.class);
        HTTP_STATUS_CODES.put(202, Accepted.class);
        HTTP_STATUS_CODES.put(203, NonAuthoritativeInformation.class);
        HTTP_STATUS_CODES.put(204, NoContent.class);
        HTTP_STATUS_CODES.put(205, ResetContent.class);
        HTTP_STATUS_CODES.put(206, PartialContent.class);
        HTTP_STATUS_CODES.put(207, MultiStatus.class);
        HTTP_STATUS_CODES.put(226, IMUsed.class);
        HTTP_STATUS_CODES.put(300, MultipleChoices.class);
        HTTP_STATUS_CODES.put(301, MovedPermanently.class);
        HTTP_STATUS_CODES.put(302, Found.class);
        HTTP_STATUS_CODES.put(303, SeeOther.class);
        HTTP_STATUS_CODES.put(304, NotModified.class);
        HTTP_STATUS_CODES.put(305, UseProxy.class);
        HTTP_STATUS_CODES.put(307, TemporaryRedirect.class);
        HTTP_STATUS_CODES.put(308, PermanentRedirect.class);
        HTTP_STATUS_CODES.put(400, BadRequest.class);
        HTTP_STATUS_CODES.put(401, Unauthorized.class);
        HTTP_STATUS_CODES.put(402, PaymentRequired.class);
        HTTP_STATUS_CODES.put(403, Forbidden.class);
        HTTP_STATUS_CODES.put(404, NotFound.class);
        HTTP_STATUS_CODES.put(405, MethodNotAllowed.class);
        HTTP_STATUS_CODES.put(406, NotAcceptable.class);
        HTTP_STATUS_CODES.put(407, ProxyAuthenticationRequired.class);
        HTTP_STATUS_CODES.put(408, RequestTimeout.class);
        HTTP_STATUS_CODES.put(409, Conflict.class);
        HTTP_STATUS_CODES.put(410, Gone.class);
        HTTP_STATUS_CODES.put(411, LengthRequired.class);
        HTTP_STATUS_CODES.put(412, PreconditionFailed.class);
        HTTP_STATUS_CODES.put(413, PayloadTooLarge.class);
        HTTP_STATUS_CODES.put(414, URITooLong.class);
        HTTP_STATUS_CODES.put(415, UnsupportedMediaType.class);
        HTTP_STATUS_CODES.put(416, RangeNotSatisfiable.class);
        HTTP_STATUS_CODES.put(417, ExpectationFailed.class);
        HTTP_STATUS_CODES.put(418, Imateapot.class);
        HTTP_STATUS_CODES.put(422, UnprocessableEntity.class);
        HTTP_STATUS_CODES.put(423, Locked.class);
        HTTP_STATUS_CODES.put(424, FailedDependency.class);
        HTTP_STATUS_CODES.put(426, UpgradeRequired.class);
        HTTP_STATUS_CODES.put(428, PreconditionRequired.class);
        HTTP_STATUS_CODES.put(429, TooManyRequests.class);
        HTTP_STATUS_CODES.put(431, RequestHeaderFieldsTooLarge.class);
        HTTP_STATUS_CODES.put(451, UnavailableForLegalReasons.class);
        HTTP_STATUS_CODES.put(500, InternalServerError.class);
        HTTP_STATUS_CODES.put(501, NotImplemented.class);
        HTTP_STATUS_CODES.put(502, BadGateway.class);
        HTTP_STATUS_CODES.put(503, ServiceUnavailable.class);
        HTTP_STATUS_CODES.put(504, GatewayTimeout.class);
        HTTP_STATUS_CODES.put(505, HTTPVersionNotSupported.class);
        HTTP_STATUS_CODES.put(506, VariantAlsoNegotiates.class);
        HTTP_STATUS_CODES.put(507, InsufficientStorage.class);
        HTTP_STATUS_CODES.put(511, NetworkAuthenticationRequired.class);
    }
}

