/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked.auth;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Objects;
import tech.greenfield.vertx.irked.auth.BasicAuthorizationToken;
import tech.greenfield.vertx.irked.auth.BearerAuthorizationToken;
import tech.greenfield.vertx.irked.auth.DigestAuthorizationToken;
import tech.greenfield.vertx.irked.auth.HOBAAuthorizationToken;
import tech.greenfield.vertx.irked.auth.MutualAuthorizationToken;
import tech.greenfield.vertx.irked.auth.NegotiateAuthorizationToken;
import tech.greenfield.vertx.irked.auth.NullAuthorizationToken;
import tech.greenfield.vertx.irked.auth.OAuthAuthorizationToken;
import tech.greenfield.vertx.irked.auth.SimpleAuthrizationToken;

public class AuthorizationToken {
    private String token;
    private String type;

    protected AuthorizationToken() {
    }

    public static AuthorizationToken parse(String authorizationHeader) {
        if (Objects.isNull(authorizationHeader)) {
            return new NullAuthorizationToken();
        }
        String[] parts = authorizationHeader.split("\\s+", 2);
        if (parts.length == 1) {
            return new SimpleAuthrizationToken(parts[0]);
        }
        for (AuthorizationToken a : TokenTypes.instances()) {
            if (!a.supports(parts[0])) continue;
            return a.update(parts[0], parts[1]);
        }
        return new AuthorizationToken().update(parts[0], parts[1]);
    }

    protected AuthorizationToken update(String type, String token) {
        this.type = type;
        this.token = token;
        return this;
    }

    protected boolean supports(String type) {
        return false;
    }

    public boolean is(String type) {
        return Objects.isNull(type) ? Objects.isNull(this.type) : type.equalsIgnoreCase(this.type);
    }

    public String getToken() {
        return this.token;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.type + " " + this.token;
    }

    public static enum TokenTypes {
        NULL(NullAuthorizationToken.class),
        SIMPLE(SimpleAuthrizationToken.class),
        BASIC(BasicAuthorizationToken.class),
        BEARER(BearerAuthorizationToken.class),
        DIGEST(DigestAuthorizationToken.class),
        HOB(HOBAAuthorizationToken.class),
        MUTUAL(MutualAuthorizationToken.class),
        NEGOTIATE(NegotiateAuthorizationToken.class),
        OAUTH(OAuthAuthorizationToken.class);

        private Class<? extends AuthorizationToken> clz;

        private TokenTypes(Class<? extends AuthorizationToken> clz) {
            this.clz = clz;
        }

        public static Iterable<AuthorizationToken> instances() {
            return new Iterable<AuthorizationToken>(){
                private TokenTypes[] types = TokenTypes.values();

                @Override
                public Iterator<AuthorizationToken> iterator() {
                    return new Iterator<AuthorizationToken>(){
                        private int index = 0;
                        private int max;
                        {
                            this.max = types.length;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.index < this.max;
                        }

                        @Override
                        public AuthorizationToken next() {
                            try {
                                return types[this.index++].clz.getConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                                System.err.print("Unexpected exception instantiating a known authorization token type! this shouldn't happen");
                                throw new Error(e);
                            }
                        }
                    };
                }
            };
        }
    }
}

