/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.AllowForwardHeaders;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.greenfield.vertx.irked.Controller;
import tech.greenfield.vertx.irked.Request;
import tech.greenfield.vertx.irked.RequestWrapper;
import tech.greenfield.vertx.irked.RouteConfiguration;
import tech.greenfield.vertx.irked.annotations.Connect;
import tech.greenfield.vertx.irked.annotations.Delete;
import tech.greenfield.vertx.irked.annotations.Endpoint;
import tech.greenfield.vertx.irked.annotations.Get;
import tech.greenfield.vertx.irked.annotations.Head;
import tech.greenfield.vertx.irked.annotations.Options;
import tech.greenfield.vertx.irked.annotations.Patch;
import tech.greenfield.vertx.irked.annotations.Post;
import tech.greenfield.vertx.irked.annotations.Put;
import tech.greenfield.vertx.irked.annotations.WebSocket;
import tech.greenfield.vertx.irked.exceptions.InvalidRouteConfiguration;

public class Router
implements io.vertx.ext.web.Router {
    static Logger log = LoggerFactory.getLogger(Router.class);
    private Vertx vertx;
    private io.vertx.ext.web.Router router;
    private Set<Route> routePaths = new HashSet<Route>();

    public Router(Vertx vertx) {
        this.vertx = vertx;
        this.router = io.vertx.ext.web.Router.router((Vertx)this.vertx);
    }

    public Router with(Controller api) throws InvalidRouteConfiguration {
        return this.with(api, "/");
    }

    public Router with(Controller api, String path) throws InvalidRouteConfiguration {
        this.configure(api, path);
        return this;
    }

    public Router remove(Controller api) {
        api.remove();
        return this;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public io.vertx.ext.web.Router vertxWebRouter() {
        return this.router;
    }

    public Router configReport() {
        return this.configReport(System.err);
    }

    public Router configReport(PrintStream reportStream) {
        reportStream.println("Configured routes:");
        this.routePaths.stream().sorted(this::routeComparator).forEach(r -> reportStream.println("  " + (r.methods() == null ? "*" : r.methods().stream().map(Object::toString).collect(Collectors.joining("|"))) + " " + r.getPath() + " -> " + this.listHandlers((Route)r)));
        return this;
    }

    private int routeComparator(Route a, Route b) {
        String[] aPath = a.getPath().split("/");
        String[] bPath = b.getPath().split("/");
        for (int i = 0; i < Math.min(aPath.length, bPath.length); ++i) {
            int c = aPath[i].compareTo(bPath[i]);
            if (c == 0) continue;
            return c;
        }
        return Integer.compare(aPath.length, bPath.length);
    }

    private String listHandlers(Route r) {
        try {
            Method m = r.getClass().getDeclaredMethod("state", new Class[0]);
            m.setAccessible(true);
            Object state = m.invoke((Object)r, new Object[0]);
            m = state.getClass().getDeclaredMethod("getContextHandlers", new Class[0]);
            m.setAccessible(true);
            List ctxhandlers = (List)m.invoke(state, new Object[0]);
            m = state.getClass().getDeclaredMethod("getFailureHandlers", new Class[0]);
            m.setAccessible(true);
            List failhandlers = (List)m.invoke(state, new Object[0]);
            return String.join((CharSequence)" ", new CharSequence[]{ctxhandlers != null && !ctxhandlers.isEmpty() ? (CharSequence)ctxhandlers.stream().map(Object::toString).collect(Collectors.joining(" ")) : "", failhandlers != null && !failhandlers.isEmpty() ? "@OnFail " + failhandlers.stream().map(Object::toString).collect(Collectors.joining(" ")) : ""}).replaceAll("\\s+", " ");
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Assumptions about Vert.x RouterImpl internal state have been broken. Please fix and/or stop calling configReport");
        }
    }

    public Router configure(Controller api) throws InvalidRouteConfiguration {
        return this.configure(api, "/");
    }

    public Router configure(Controller api, String path) throws InvalidRouteConfiguration {
        this.configure(api, path, new RequestWrapper(api));
        return this;
    }

    private void configure(Controller api, String prefix, RequestWrapper requestWrapper) throws InvalidRouteConfiguration {
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        for (RouteConfiguration f : api.getRoutes(this)) {
            this.tryConfigureRoute(arg_0 -> ((io.vertx.ext.web.Router)this.router).route(arg_0), prefix, f, Endpoint.class, requestWrapper);
            this.tryConfigureRoute(arg_0 -> ((io.vertx.ext.web.Router)this.router).post(arg_0), prefix, f, Post.class, requestWrapper);
            this.tryConfigureRoute(arg_0 -> ((io.vertx.ext.web.Router)this.router).get(arg_0), prefix, f, Get.class, requestWrapper);
            this.tryConfigureRoute(arg_0 -> ((io.vertx.ext.web.Router)this.router).put(arg_0), prefix, f, Put.class, requestWrapper);
            this.tryConfigureRoute(arg_0 -> ((io.vertx.ext.web.Router)this.router).delete(arg_0), prefix, f, Delete.class, requestWrapper);
            this.tryConfigureRoute(arg_0 -> ((io.vertx.ext.web.Router)this.router).patch(arg_0), prefix, f, Patch.class, requestWrapper);
            this.tryConfigureRoute(arg_0 -> ((io.vertx.ext.web.Router)this.router).head(arg_0), prefix, f, Head.class, requestWrapper);
            this.tryConfigureRoute(arg_0 -> ((io.vertx.ext.web.Router)this.router).options(arg_0), prefix, f, Options.class, requestWrapper);
            this.tryConfigureRoute(arg_0 -> ((io.vertx.ext.web.Router)this.router).connect(arg_0), prefix, f, Connect.class, requestWrapper);
            this.tryConfigureRoute(arg_0 -> ((io.vertx.ext.web.Router)this.router).get(arg_0), prefix, f, WebSocket.class, requestWrapper);
        }
    }

    private <T extends Annotation> void tryConfigureRoute(RoutingMethod method, String prefix, RouteConfiguration conf, Class<T> anot, RequestWrapper requestWrapper) throws InvalidRouteConfiguration {
        if (conf.isController()) {
            Controller ctr = Objects.requireNonNull(conf.getController(), "Sub-Controller for " + conf + " is not set!");
            for (String path : conf.pathsForAnnotation(prefix, anot).collect(Collectors.toList())) {
                this.configure(ctr, path, new RequestWrapper(ctr, (Function<RoutingContext, Request>)requestWrapper));
            }
            return;
        }
        conf.buildRoutesFor(prefix, anot, method, requestWrapper).forEach(this.routePaths::add);
    }

    public Route route() {
        return this.router.route();
    }

    public Route route(HttpMethod method, String path) {
        return this.router.route(method, path);
    }

    public Route route(String path) {
        return this.router.route(path);
    }

    public Route routeWithRegex(HttpMethod method, String regex) {
        return this.router.routeWithRegex(method, regex);
    }

    public Route routeWithRegex(String regex) {
        return this.router.routeWithRegex(regex);
    }

    public Route get() {
        return this.router.get();
    }

    public Route get(String path) {
        return this.router.get(path);
    }

    public Route getWithRegex(String regex) {
        return this.router.getWithRegex(regex);
    }

    public Route head() {
        return this.router.head();
    }

    public Route head(String path) {
        return this.router.head(path);
    }

    public Route headWithRegex(String regex) {
        return this.router.headWithRegex(regex);
    }

    public Route options() {
        return this.router.options();
    }

    public Route options(String path) {
        return this.router.options(path);
    }

    public Route optionsWithRegex(String regex) {
        return this.router.optionsWithRegex(regex);
    }

    public Route put() {
        return this.router.put();
    }

    public Route put(String path) {
        return this.router.put(path);
    }

    public Route putWithRegex(String regex) {
        return this.router.putWithRegex(regex);
    }

    public Route post() {
        return this.router.post();
    }

    public Route post(String path) {
        return this.router.post(path);
    }

    public Route postWithRegex(String regex) {
        return this.router.postWithRegex(regex);
    }

    public Route delete() {
        return this.router.delete();
    }

    public Route delete(String path) {
        return this.router.delete(path);
    }

    public Route deleteWithRegex(String regex) {
        return this.router.deleteWithRegex(regex);
    }

    public Route trace() {
        return this.router.trace();
    }

    public Route trace(String path) {
        return this.router.trace(path);
    }

    public Route traceWithRegex(String regex) {
        return this.router.traceWithRegex(regex);
    }

    public Route connect() {
        return this.router.connect();
    }

    public Route connect(String path) {
        return this.router.connect(path);
    }

    public Route connectWithRegex(String regex) {
        return this.router.connectWithRegex(regex);
    }

    public Route patch() {
        return this.router.patch();
    }

    public Route patch(String path) {
        return this.router.patch(path);
    }

    public Route patchWithRegex(String regex) {
        return this.router.patchWithRegex(regex);
    }

    public List<Route> getRoutes() {
        return this.router.getRoutes();
    }

    public io.vertx.ext.web.Router clear() {
        return this.router.clear();
    }

    @Deprecated
    public Route mountSubRouter(String mountPoint, io.vertx.ext.web.Router subRouter) {
        return this.router.mountSubRouter(mountPoint, subRouter);
    }

    public void handleContext(RoutingContext context) {
        this.router.handleContext(context);
    }

    public void handleFailure(RoutingContext context) {
        this.router.handleFailure(context);
    }

    public void handle(HttpServerRequest event) {
        this.router.handle((Object)event);
    }

    public Router errorHandler(int statusCode, Handler<RoutingContext> errorHandler) {
        this.router.errorHandler(statusCode, errorHandler);
        return this;
    }

    public Router modifiedHandler(Handler<io.vertx.ext.web.Router> handler) {
        this.router.modifiedHandler(handler);
        return this;
    }

    public Router allowForward(AllowForwardHeaders allowForwardHeaders) {
        this.router.allowForward(allowForwardHeaders);
        return this;
    }

    public io.vertx.ext.web.Router putMetadata(String key, Object value) {
        return this.router.putMetadata(key, value);
    }

    public Map<String, Object> metadata() {
        return this.router.metadata();
    }

    @FunctionalInterface
    static interface RoutingMethod {
        public Route getRoute(String var1);
    }
}

