/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked;

import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.TimeoutHandler;
import io.vertx.ext.web.impl.BlockingHandlerDecorator;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.greenfield.vertx.irked.Controller;
import tech.greenfield.vertx.irked.HttpError;
import tech.greenfield.vertx.irked.Request;
import tech.greenfield.vertx.irked.RequestWrapper;
import tech.greenfield.vertx.irked.RouteConfigurationField;
import tech.greenfield.vertx.irked.RouteConfigurationMethod;
import tech.greenfield.vertx.irked.Router;
import tech.greenfield.vertx.irked.WebSocketUpgradeRequestWrapper;
import tech.greenfield.vertx.irked.annotations.Blocking;
import tech.greenfield.vertx.irked.annotations.Consumes;
import tech.greenfield.vertx.irked.annotations.Endpoint;
import tech.greenfield.vertx.irked.annotations.OnFail;
import tech.greenfield.vertx.irked.annotations.Order;
import tech.greenfield.vertx.irked.annotations.RouteSpec;
import tech.greenfield.vertx.irked.annotations.Timeout;
import tech.greenfield.vertx.irked.annotations.WebSocket;
import tech.greenfield.vertx.irked.exceptions.InvalidRouteConfiguration;
import tech.greenfield.vertx.irked.status.BadRequest;
import tech.greenfield.vertx.irked.status.InternalServerError;
import tech.greenfield.vertx.irked.websocket.WebSocketMessage;

public abstract class RouteConfiguration {
    static final Package annotationPackage = Endpoint.class.getPackage();
    static final Class<Annotation>[] routeAnnotations = RouteConfiguration.findRouteAnnotations();
    protected Annotation[] annotations;
    protected Router router;
    protected Controller impl;
    protected Class<? extends RoutingContext> routingContextType = Request.class;
    protected Function<Request, Request> routingContextResolver;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static Pattern trailingSlashRemover;
    private static boolean normalizeSlashWildcardEnd;
    private List<Route> routes = new ArrayList<Route>();

    protected RouteConfiguration(Controller impl, Router router, Annotation[] annotations) {
        this.annotations = annotations;
        this.router = router;
        this.impl = impl;
    }

    protected void trySetRoutingContextType(Class<?> type) {
        if (!RoutingContext.class.isAssignableFrom(type)) {
            return;
        }
        this.routingContextType = type;
        if (!this.routingContextType.isAssignableFrom(Request.class)) {
            this.routingContextResolver = this.findRoutingContextResolver();
        }
    }

    static RouteConfiguration wrap(Controller impl, Router router, Field f) {
        return new RouteConfigurationField(impl, router, f);
    }

    static RouteConfiguration wrap(Controller impl, Router router, Method m) throws InvalidRouteConfiguration {
        return new RouteConfigurationMethod(impl, router, m);
    }

    boolean isValid() {
        return Arrays.stream(this.annotations).map(a -> a.annotationType().getPackage()).anyMatch(p -> p.equals(annotationPackage));
    }

    protected String[] uriForAnnotations(Class<?> ... anot) {
        if (anot.length == 0) {
            anot = routeAnnotations;
        }
        ArrayList uris = new ArrayList();
        for (Class<Object> a : anot) {
            uris.addAll(this.uriForAnnotation(a).collect(Collectors.toList()));
        }
        return (String[])uris.toArray(String[]::new);
    }

    <T extends Annotation> Stream<String> uriForAnnotation(Class<T> anot) {
        try {
            return Arrays.stream(this.getAnnotation(anot)).map(s -> this.annotationToValue((Annotation)s)).filter(s -> Objects.nonNull(s));
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String annotationToValue(Annotation anot) {
        try {
            return anot.getClass().getMethod("value", new Class[0]).invoke((Object)anot, new Object[0]).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract <T extends Annotation> T[] getAnnotation(Class<T> var1);

    abstract boolean isController();

    abstract Controller getController();

    public String toString() {
        return this.impl.getClass() + "::" + this.getName();
    }

    protected abstract String getName();

    abstract Handler<? super Request> getHandler() throws IllegalArgumentException, IllegalAccessException, InvalidRouteConfiguration;

    abstract Handler<? super WebSocketMessage> getMessageHandler() throws IllegalArgumentException, IllegalAccessException, InvalidRouteConfiguration;

    private Handler<? super Request> getFailureHandler() throws IllegalArgumentException, IllegalAccessException, InvalidRouteConfiguration {
        Handler<? super Request> userHandler = this.getHandler();
        OnFail[] failSpecs = (OnFail[])this.getAnnotation(OnFail.class);
        return req -> {
            int statusCode = req.statusCode();
            for (OnFail onfail : failSpecs) {
                boolean failureMatchOrUnknown;
                Class<? extends Throwable> ex = onfail.exception();
                Throwable foundException = null;
                boolean statusMatchOrUnknown = onfail.status() == -1 || statusCode == onfail.status();
                boolean bl = failureMatchOrUnknown = Objects.equals(ex, Throwable.class) || (foundException = req.findFailure(ex)) != null;
                if (!statusMatchOrUnknown || !failureMatchOrUnknown) continue;
                if (foundException != null) {
                    req.setSpecificFailure(foundException);
                }
                userHandler.handle((Object)req);
                return;
            }
            req.next();
        };
    }

    boolean isBlocking() {
        return ((Blocking[])this.getAnnotation(Blocking.class)).length > 0;
    }

    boolean isFailHandler() {
        return ((OnFail[])this.getAnnotation(OnFail.class)).length > 0;
    }

    boolean hasConsumes() {
        return ((Consumes[])this.getAnnotation(Consumes.class)).length > 0;
    }

    boolean hasOrder() {
        return ((Order[])this.getAnnotation(Order.class)).length > 0;
    }

    Timeout trygetTimeout() {
        Timeout[] ts = (Timeout[])this.getAnnotation(Timeout.class);
        return ts.length > 0 ? ts[0] : null;
    }

    private Stream<String> consumes() {
        return Arrays.stream((Consumes[])this.getAnnotation(Consumes.class)).map(a -> a.value());
    }

    private int order() {
        return Arrays.stream((Order[])this.getAnnotation(Order.class)).findAny().map(Order::value).orElse(0);
    }

    public <T extends Annotation> Stream<String> pathsForAnnotation(String prefix, Class<T> anot) {
        return this.uriForAnnotation(anot).filter(s -> Objects.nonNull(s)).map(s -> prefix + s).flatMap(s -> {
            if (normalizeSlashWildcardEnd && s.contains(":") && s.endsWith("/*")) {
                return Stream.of(s, s.substring(0, s.length() - 1));
            }
            return Stream.of(s);
        }).map(s -> trailingSlashRemover.matcher((CharSequence)s).find() ? s.substring(0, s.length() - 1) : s);
    }

    public <T extends Annotation> List<Route> buildRoutesFor(String prefix, Class<T> anot, Router.RoutingMethod method, RequestWrapper requestWrapper) throws InvalidRouteConfiguration {
        LinkedList<Route> out = new LinkedList<Route>();
        for (Route r : this.pathsForAnnotation(prefix, anot).flatMap(s -> this.getRoutes(method, (String)s)).collect(Collectors.toList())) {
            try {
                if (anot.equals(WebSocket.class)) {
                    r.handler(this.getWebSocketHandler(requestWrapper));
                } else if (this.isFailHandler()) {
                    r.failureHandler(this.wrapHandler(requestWrapper, this.getFailureHandler()));
                } else {
                    r.handler(this.wrapHandler(requestWrapper, this.getHandler()));
                }
            }
            catch (IllegalAccessException e) {
                throw new InvalidRouteConfiguration("Illegal access error while trying to configure " + this);
            }
            this.routes.add(r);
            out.add(r);
        }
        return out;
    }

    private Stream<Route> getRoutes(Router.RoutingMethod method, String s) {
        return this.getRoutes(method, s, true).map(r -> this.hasOrder() ? r.order(this.order()) : r);
    }

    private Stream<Route> getRoutes(Router.RoutingMethod method, String s, boolean withTimeout) {
        Timeout t;
        if (withTimeout && (t = this.trygetTimeout()) != null) {
            return this.getRoutes(method, s, false).map(r -> r.handler((Handler)TimeoutHandler.create((long)t.value())));
        }
        if (!this.hasConsumes()) {
            return Stream.of(method.getRoute(s));
        }
        return this.consumes().map(c -> method.getRoute(s).consumes(c));
    }

    private Handler<RoutingContext> wrapHandler(RequestWrapper parent, Handler<? super Request> userHandler) throws IllegalArgumentException, InvalidRouteConfiguration {
        RequestWrapper handler = new RequestWrapper(Objects.requireNonNull(userHandler), (Function<RoutingContext, Request>)parent);
        if (this.isBlocking()) {
            handler = new BlockingHandlerDecorator((Handler)handler, true);
        }
        return handler;
    }

    private Handler<RoutingContext> getWebSocketHandler(RequestWrapper parent) throws IllegalArgumentException, InvalidRouteConfiguration {
        try {
            return new WebSocketUpgradeRequestWrapper(Objects.requireNonNull(this.getMessageHandler()), parent);
        }
        catch (IllegalAccessException e) {
            throw new InvalidRouteConfiguration("Illegal access error while trying to configure " + this);
        }
    }

    void remove() {
        this.routes.forEach(Route::remove);
    }

    protected void handleUserException(Request r, Throwable cause, String invocationDescription) {
        if (r.failed()) {
            if (r.response().headWritten()) {
                this.log.error("Exception in user fail route '{}', after response started - ignoring", (Object)r.normalizedPath(), (Object)cause);
                if (!r.response().ended()) {
                    r.response().end();
                }
                return;
            }
            this.log.warn("Exception in user fail route '{}', issuing ISE!", (Object)r.normalizedPath(), (Object)cause);
            r.send(new InternalServerError());
        }
        if (HttpError.unwrap(cause) instanceof HttpError) {
            r.fail(HttpError.toHttpError(cause));
        } else if (invocationDescription.contains("io.vertx.ext.web") && cause instanceof IllegalStateException) {
            this.log.warn("Handler {} encountered an illegal state: {}", new Object[]{invocationDescription, cause.getMessage(), cause});
            r.fail(new BadRequest("Illegal state in request", cause));
        } else {
            this.log.error("Handler {} threw an unexpected exception", (Object)invocationDescription, (Object)cause);
            r.fail(cause);
        }
    }

    protected void handleUserException(WebSocketMessage m, Throwable cause, String invocationDescription) {
        Throwable err = HttpError.unwrap(cause);
        if (err instanceof HttpError) {
            m.socket().close((short)1002, ((HttpError)err).getMessage());
        } else {
            this.log.error("Handler " + invocationDescription + " threw an unexpected exception", cause);
            m.socket().close((short)1011, cause.getMessage());
        }
    }

    protected Function<Request, Request> findRoutingContextResolver() {
        for (Class<?> ctrImpl = this.impl.getClass(); ctrImpl != Controller.class; ctrImpl = ctrImpl.getSuperclass()) {
            for (Method m : ctrImpl.getDeclaredMethods()) {
                if (!m.getReturnType().equals(this.routingContextType) || m.getParameterCount() != 1 || !m.getParameterTypes()[0].isAssignableFrom(Request.class)) continue;
                return r -> {
                    m.setAccessible(true);
                    try {
                        return (Request)((Object)((Object)m.invoke((Object)this.impl, r)));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new RoutingContextImplException(e);
                    }
                };
            }
        }
        return null;
    }

    protected Request resolveRequestContext(Request r) throws RoutingContextImplException {
        if (this.routingContextResolver != null) {
            r = this.routingContextResolver.apply(r);
        }
        if (this.routingContextType.isAssignableFrom(((Object)((Object)r)).getClass())) {
            return r;
        }
        for (Constructor<?> ctor : this.routingContextType.getConstructors()) {
            Class<?> p0;
            if (ctor.getParameterCount() != 1 || !(p0 = ctor.getParameterTypes()[0]).isAssignableFrom(((Object)((Object)r)).getClass())) continue;
            try {
                return (Request)((Object)ctor.newInstance(new Object[]{r}));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new RoutingContextImplException(e);
            }
        }
        throw new RoutingContextImplException(String.format("Invalid request handler %s: routing context param %s is not trivially constructed from a Request instance! If you want to use non-trivially constructed programmable requests contexts, implement Controller.getRequest(Request)", this, this.routingContextType));
    }

    private static Class<Annotation>[] findRouteAnnotations() {
        String packageName = annotationPackage.getName();
        InputStream annotationsList = Endpoint.class.getClassLoader().getResourceAsStream(packageName.replaceAll("[.]", "/") + "/annotations.list");
        if (annotationsList == null) {
            return new Class[0];
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(annotationsList));
        return (Class[])reader.lines().map(name -> packageName + "." + name).map(className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }).filter(Objects::nonNull).filter(c -> c.isAnnotation()).filter(c -> c.getAnnotation(RouteSpec.class) != null).map(c -> c).collect(Collectors.toSet()).toArray(Class[]::new);
    }

    static {
        if (routeAnnotations.length == 0) {
            throw new RuntimeException("Irked failed to list routing annotations in " + annotationPackage + "!");
        }
        trailingSlashRemover = Pattern.compile("./$");
        normalizeSlashWildcardEnd = System.getProperty("irked.disable-normalize-wildcard-path-end") == null;
    }

    protected class RoutingContextImplException
    extends RuntimeException {
        private static final long serialVersionUID = 3549348052777343128L;

        public RoutingContextImplException(String message) {
            super(message);
        }

        public RoutingContextImplException(Exception e) {
            super(String.format("Failed to construct routing context param for %s from Request instance", RouteConfiguration.this), e);
        }
    }
}

