/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.OrderListener;
import java.util.Objects;
import java.util.function.Function;
import tech.greenfield.vertx.irked.Controller;
import tech.greenfield.vertx.irked.Request;

public class RequestWrapper
implements Function<RoutingContext, Request>,
Handler<RoutingContext>,
OrderListener {
    private Type type;
    private Controller ctr;
    protected Function<RoutingContext, Request> wrapper;
    private Handler<? super Request> handler;

    public RequestWrapper(Controller ctr) {
        this(ctr, Request::new);
        this.type = Type.Root;
    }

    public RequestWrapper(Controller ctr, Function<RoutingContext, Request> requestWrapper) {
        this.ctr = Objects.requireNonNull(ctr, "Controller instance is not set!");
        this.wrapper = requestWrapper;
        this.type = Type.Controller;
    }

    public RequestWrapper(Handler<? super Request> handler, Function<RoutingContext, Request> requestWrapper) {
        this.handler = Objects.requireNonNull(handler, "Handler instance is not set!");
        this.wrapper = requestWrapper;
        this.type = Type.Handler;
    }

    protected RequestWrapper(Function<RoutingContext, Request> parent) {
        this.wrapper = parent;
        this.type = Type.Custom;
    }

    @Override
    public Request apply(RoutingContext r) {
        return this.ctr.getRequestContext(this.wrapper.apply(r));
    }

    public void handle(RoutingContext r) {
        this.handler.handle((Object)this.wrapper.apply(r));
    }

    public String toString() {
        switch (this.type) {
            case Root: {
                return "HTTP=>" + this.ctr;
            }
            case Controller: {
                return this.wrapper + "->" + this.ctr;
            }
            case Handler: {
                return this.wrapper + "." + this.handler;
            }
        }
        return this.wrapper + "->?";
    }

    public void onOrder(int order) {
        switch (this.type) {
            case Handler: {
                if (!(this.handler instanceof OrderListener)) break;
                ((OrderListener)this.handler).onOrder(order);
                break;
            }
            case Custom: {
                break;
            }
        }
    }

    private static enum Type {
        Root,
        Controller,
        Handler,
        Custom;

    }
}

