/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.handler.LoggerFormat;
import io.vertx.ext.web.handler.LoggerHandler;
import io.vertx.ext.web.handler.impl.LoggerHandlerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.greenfield.vertx.irked.Controller;
import tech.greenfield.vertx.irked.Router;
import tech.greenfield.vertx.irked.exceptions.InvalidRouteConfiguration;

public class Irked {
    private Vertx vertx;

    public static Irked irked(Vertx vertx) {
        return new Irked(vertx);
    }

    @Deprecated(forRemoval=true)
    public Irked(Vertx vertx) {
        this.vertx = vertx;
    }

    public Handler<HttpServerRequest> setupRequestHandler(Controller ... apis) throws InvalidRouteConfiguration {
        Router router = new Router(this.vertx);
        for (Controller api : apis) {
            router.configure(api);
        }
        return router;
    }

    public Router router() {
        return new Router(this.vertx);
    }

    public static Router router(Vertx vertx) {
        return new Router(vertx);
    }

    public static LoggerHandler logger() {
        return Irked.logger("access", LoggerFormat.DEFAULT);
    }

    public static LoggerHandler logger(LoggerFormat format) {
        return Irked.logger("access", format);
    }

    public static LoggerHandler logger(final String loggerName, LoggerFormat format) {
        return new LoggerHandlerImpl(format){
            private Logger LOG;
            {
                super(arg0);
                this.LOG = LoggerFactory.getLogger((String)loggerName);
            }

            protected void doLog(int status, String message) {
                if (status >= 500) {
                    this.LOG.error(message);
                } else if (status >= 400) {
                    this.LOG.warn(message);
                } else {
                    this.LOG.info(message);
                }
            }
        };
    }
}

