/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked;

import io.vertx.core.MultiMap;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import tech.greenfield.vertx.irked.status.HttpStatuses;
import tech.greenfield.vertx.irked.status.InternalServerError;
import tech.greenfield.vertx.irked.status.OK;

public class HttpError
extends Exception {
    private static final long serialVersionUID = -7084405660609573926L;
    private int statusCode;
    private String statusText;
    private HeadersMultiMap headers = HeadersMultiMap.httpHeaders();

    public HttpError(int statusCode, String statusText) {
        super(statusText);
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    public HttpError(int statusCode, String statusText, String message) {
        super(message);
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    public HttpError(int statusCode, String statusText, Throwable throwable) {
        super(statusText, throwable);
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    public HttpError(int statusCode, String statusText, String message, Throwable throwable) {
        super(message, throwable);
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public HttpError setStatusText(String reasonText) {
        this.statusText = reasonText;
        return this;
    }

    public boolean isOK() {
        return this.statusCode / 100 == 2;
    }

    public boolean isRedirect() {
        return this.statusCode / 100 == 3;
    }

    public boolean isClientError() {
        return this.statusCode / 100 == 4;
    }

    public boolean isServerError() {
        return this.statusCode / 100 == 5;
    }

    public boolean isError() {
        return this.isClientError() || this.isServerError();
    }

    public HttpError addHeader(String header, String value) {
        this.headers.add(header, value);
        return this;
    }

    public MultiMap getHeaders() {
        return this.headers;
    }

    public RuntimeException uncheckedWrap() {
        return new UncheckedHttpError();
    }

    public RuntimeException unchecked() {
        return new UncheckedHttpError();
    }

    public static Throwable unwrap(Throwable t) {
        Throwable ex;
        for (ex = t; ex != null; ex = ex.getCause()) {
            if (!(ex instanceof HttpError)) continue;
            return ex;
        }
        for (ex = t; ex != null; ex = ex.getCause()) {
            if (ex instanceof RuntimeException) continue;
            return ex;
        }
        return t;
    }

    public static HttpError toHttpError(Throwable t) {
        if ((t = HttpError.unwrap(t)) instanceof HttpError) {
            return (HttpError)t;
        }
        return new InternalServerError(t);
    }

    public static HttpError toHttpError(RoutingContext ctx) {
        if (!ctx.failed()) {
            return new OK();
        }
        if (Objects.nonNull(ctx.failure())) {
            return HttpError.toHttpError(ctx.failure());
        }
        if (!HttpStatuses.HTTP_STATUS_CODES.containsKey(ctx.statusCode())) {
            return new InternalServerError("Unknown HTTP status code " + ctx.statusCode());
        }
        try {
            return HttpStatuses.create(ctx.statusCode());
        }
        catch (InstantiationException e) {
            return new InternalServerError("Failed to translate failed context to HTTP error");
        }
    }

    @Override
    public String toString() {
        return "HTTP " + this.statusCode + " " + this.statusText;
    }

    public class UncheckedHttpError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private UncheckedHttpError() {
            super(HttpError.this);
        }
    }
}

