/*
 * Decompiled with CFR 0.152.
 */
package tech.greenfield.vertx.irked;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import tech.greenfield.vertx.irked.Request;
import tech.greenfield.vertx.irked.RouteConfiguration;
import tech.greenfield.vertx.irked.Router;
import tech.greenfield.vertx.irked.exceptions.InvalidRouteConfiguration;
import tech.greenfield.vertx.irked.websocket.WebSocketMessage;

public abstract class Controller {
    private List<RouteConfiguration> routes;

    protected Request getRequestContext(Request request) {
        return request;
    }

    List<RouteConfiguration> getRoutes(Router router) throws InvalidRouteConfiguration {
        ArrayList<RouteConfiguration> out = new ArrayList<RouteConfiguration>();
        Class<?> ctrClass = this.getClass();
        while (!ctrClass.equals(Controller.class)) {
            for (Field field : ctrClass.getDeclaredFields()) {
                out.add(RouteConfiguration.wrap(this, router, field));
            }
            for (AccessibleObject accessibleObject : ctrClass.getDeclaredMethods()) {
                out.add(RouteConfiguration.wrap(this, router, (Method)accessibleObject));
            }
            ctrClass = ctrClass.getSuperclass();
        }
        this.routes = out.stream().filter(RouteConfiguration::isValid).collect(Collectors.toList());
        return this.routes;
    }

    Handler<RoutingContext> getHandler(Field field) {
        try {
            field.setAccessible(true);
            if (Handler.class.isAssignableFrom(field.getType())) {
                return (Handler)field.get(this);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Error accessing field " + field + ": " + e, e);
        }
    }

    Controller getController(Field field) {
        try {
            field.setAccessible(true);
            if (Controller.class.isAssignableFrom(field.getType())) {
                return (Controller)field.get(this);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Error accessing field " + field + ": " + e, e);
        }
    }

    public void remove() {
        this.routes.forEach(RouteConfiguration::remove);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected static interface MessageHandler
    extends Handler<WebSocketMessage> {
    }

    protected static interface WebHandler
    extends Handler<Request> {
    }

    protected static interface RawVertxHandler
    extends Handler<RoutingContext> {
    }
}

