package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Variant Also Negotiates
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class VariantAlsoNegotiates extends HttpError {

private static final long serialVersionUID = -1844956786557516500L;

/** HTTP status code for 'Variant Also Negotiates' */
public static final int code = 506;

/** Create a 'Variant Also Negotiates' HTTP Response. */
public VariantAlsoNegotiates() {
super(506,"Variant Also Negotiates");
}

/** Create a 'Variant Also Negotiates' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public VariantAlsoNegotiates(Throwable t) {
super(506,"Variant Also Negotiates", t);
}

/** Create a 'Variant Also Negotiates' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public VariantAlsoNegotiates(String m) {
super(506,"Variant Also Negotiates", m);
}

/** Create a 'Variant Also Negotiates' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public VariantAlsoNegotiates(String m, Throwable t) {
super(506,"Variant Also Negotiates", m, t);
}

}
