package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Upgrade Required
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class UpgradeRequired extends HttpError {

private static final long serialVersionUID = 5150210795893939846L;

/** HTTP status code for 'Upgrade Required' */
public static final int code = 426;

/** Create a 'Upgrade Required' HTTP Response. */
public UpgradeRequired() {
super(426,"Upgrade Required");
}

/** Create a 'Upgrade Required' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public UpgradeRequired(Throwable t) {
super(426,"Upgrade Required", t);
}

/** Create a 'Upgrade Required' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public UpgradeRequired(String m) {
super(426,"Upgrade Required", m);
}

/** Create a 'Upgrade Required' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public UpgradeRequired(String m, Throwable t) {
super(426,"Upgrade Required", m, t);
}

}
