package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Unprocessable Entity
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class UnprocessableEntity extends HttpError {

private static final long serialVersionUID = 1659300309947140064L;

/** HTTP status code for 'Unprocessable Entity' */
public static final int code = 422;

/** Create a 'Unprocessable Entity' HTTP Response. */
public UnprocessableEntity() {
super(422,"Unprocessable Entity");
}

/** Create a 'Unprocessable Entity' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public UnprocessableEntity(Throwable t) {
super(422,"Unprocessable Entity", t);
}

/** Create a 'Unprocessable Entity' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public UnprocessableEntity(String m) {
super(422,"Unprocessable Entity", m);
}

/** Create a 'Unprocessable Entity' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public UnprocessableEntity(String m, Throwable t) {
super(422,"Unprocessable Entity", m, t);
}

}
