package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Unavailable For Legal Reasons
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class UnavailableForLegalReasons extends HttpError {

private static final long serialVersionUID = -8578844944609322943L;

/** HTTP status code for 'Unavailable For Legal Reasons' */
public static final int code = 451;

/** Create a 'Unavailable For Legal Reasons' HTTP Response. */
public UnavailableForLegalReasons() {
super(451,"Unavailable For Legal Reasons");
}

/** Create a 'Unavailable For Legal Reasons' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public UnavailableForLegalReasons(Throwable t) {
super(451,"Unavailable For Legal Reasons", t);
}

/** Create a 'Unavailable For Legal Reasons' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public UnavailableForLegalReasons(String m) {
super(451,"Unavailable For Legal Reasons", m);
}

/** Create a 'Unavailable For Legal Reasons' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public UnavailableForLegalReasons(String m, Throwable t) {
super(451,"Unavailable For Legal Reasons", m, t);
}

}
