package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for URI Too Long
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class URITooLong extends HttpError {

private static final long serialVersionUID = 1246174329498394922L;

/** HTTP status code for 'URI Too Long' */
public static final int code = 414;

/** Create a 'URI Too Long' HTTP Response. */
public URITooLong() {
super(414,"URI Too Long");
}

/** Create a 'URI Too Long' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public URITooLong(Throwable t) {
super(414,"URI Too Long", t);
}

/** Create a 'URI Too Long' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public URITooLong(String m) {
super(414,"URI Too Long", m);
}

/** Create a 'URI Too Long' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public URITooLong(String m, Throwable t) {
super(414,"URI Too Long", m, t);
}

}
