package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Too Many Requests
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class TooManyRequests extends HttpError {

private static final long serialVersionUID = -9056415387376471919L;

/** HTTP status code for 'Too Many Requests' */
public static final int code = 429;

/** Create a 'Too Many Requests' HTTP Response. */
public TooManyRequests() {
super(429,"Too Many Requests");
}

/** Create a 'Too Many Requests' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public TooManyRequests(Throwable t) {
super(429,"Too Many Requests", t);
}

/** Create a 'Too Many Requests' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public TooManyRequests(String m) {
super(429,"Too Many Requests", m);
}

/** Create a 'Too Many Requests' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public TooManyRequests(String m, Throwable t) {
super(429,"Too Many Requests", m, t);
}

}
