package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Switching Protocols
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class SwitchingProtocols extends HttpError {

private static final long serialVersionUID = -2597335476422841702L;

/** HTTP status code for 'Switching Protocols' */
public static final int code = 101;

/** Create a 'Switching Protocols' HTTP Response. */
public SwitchingProtocols() {
super(101,"Switching Protocols");
}

/** Create a 'Switching Protocols' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public SwitchingProtocols(Throwable t) {
super(101,"Switching Protocols", t);
}

/** Create a 'Switching Protocols' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public SwitchingProtocols(String m) {
super(101,"Switching Protocols", m);
}

/** Create a 'Switching Protocols' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public SwitchingProtocols(String m, Throwable t) {
super(101,"Switching Protocols", m, t);
}

}
