package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for See Other
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class SeeOther extends HttpError {

private static final long serialVersionUID = 7265847822276711617L;

/** HTTP status code for 'See Other' */
public static final int code = 303;

/** Create a 'See Other' HTTP Response. */
public SeeOther() {
super(303,"See Other");
}

/** Create a 'See Other' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public SeeOther(Throwable t) {
super(303,"See Other", t);
}

/** Create a 'See Other' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public SeeOther(String m) {
super(303,"See Other", m);
}

/** Create a 'See Other' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public SeeOther(String m, Throwable t) {
super(303,"See Other", m, t);
}

}
