package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Request Header Fields Too Large
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class RequestHeaderFieldsTooLarge extends HttpError {

private static final long serialVersionUID = -8229569353036882299L;

/** HTTP status code for 'Request Header Fields Too Large' */
public static final int code = 431;

/** Create a 'Request Header Fields Too Large' HTTP Response. */
public RequestHeaderFieldsTooLarge() {
super(431,"Request Header Fields Too Large");
}

/** Create a 'Request Header Fields Too Large' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public RequestHeaderFieldsTooLarge(Throwable t) {
super(431,"Request Header Fields Too Large", t);
}

/** Create a 'Request Header Fields Too Large' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public RequestHeaderFieldsTooLarge(String m) {
super(431,"Request Header Fields Too Large", m);
}

/** Create a 'Request Header Fields Too Large' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public RequestHeaderFieldsTooLarge(String m, Throwable t) {
super(431,"Request Header Fields Too Large", m, t);
}

}
