package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Proxy Authentication Required
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class ProxyAuthenticationRequired extends HttpError {

private static final long serialVersionUID = 213430167513597946L;

/** HTTP status code for 'Proxy Authentication Required' */
public static final int code = 407;

/** Create a 'Proxy Authentication Required' HTTP Response. */
public ProxyAuthenticationRequired() {
super(407,"Proxy Authentication Required");
}

/** Create a 'Proxy Authentication Required' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public ProxyAuthenticationRequired(Throwable t) {
super(407,"Proxy Authentication Required", t);
}

/** Create a 'Proxy Authentication Required' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public ProxyAuthenticationRequired(String m) {
super(407,"Proxy Authentication Required", m);
}

/** Create a 'Proxy Authentication Required' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public ProxyAuthenticationRequired(String m, Throwable t) {
super(407,"Proxy Authentication Required", m, t);
}

}
