package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Network Authentication Required
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class NetworkAuthenticationRequired extends HttpError {

private static final long serialVersionUID = 1859897358751397211L;

/** HTTP status code for 'Network Authentication Required' */
public static final int code = 511;

/** Create a 'Network Authentication Required' HTTP Response. */
public NetworkAuthenticationRequired() {
super(511,"Network Authentication Required");
}

/** Create a 'Network Authentication Required' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public NetworkAuthenticationRequired(Throwable t) {
super(511,"Network Authentication Required", t);
}

/** Create a 'Network Authentication Required' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public NetworkAuthenticationRequired(String m) {
super(511,"Network Authentication Required", m);
}

/** Create a 'Network Authentication Required' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public NetworkAuthenticationRequired(String m, Throwable t) {
super(511,"Network Authentication Required", m, t);
}

}
