package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Multiple Choices
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class MultipleChoices extends HttpError {

private static final long serialVersionUID = -5831464411691598964L;

/** HTTP status code for 'Multiple Choices' */
public static final int code = 300;

/** Create a 'Multiple Choices' HTTP Response. */
public MultipleChoices() {
super(300,"Multiple Choices");
}

/** Create a 'Multiple Choices' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public MultipleChoices(Throwable t) {
super(300,"Multiple Choices", t);
}

/** Create a 'Multiple Choices' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public MultipleChoices(String m) {
super(300,"Multiple Choices", m);
}

/** Create a 'Multiple Choices' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public MultipleChoices(String m, Throwable t) {
super(300,"Multiple Choices", m, t);
}

}
