package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Locked
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class Locked extends HttpError {

private static final long serialVersionUID = 4299752439408413552L;

/** HTTP status code for 'Locked' */
public static final int code = 423;

/** Create a 'Locked' HTTP Response. */
public Locked() {
super(423,"Locked");
}

/** Create a 'Locked' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public Locked(Throwable t) {
super(423,"Locked", t);
}

/** Create a 'Locked' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public Locked(String m) {
super(423,"Locked", m);
}

/** Create a 'Locked' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public Locked(String m, Throwable t) {
super(423,"Locked", m, t);
}

}
