package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for Length Required
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class LengthRequired extends HttpError {

private static final long serialVersionUID = -5064552170851849516L;

/** HTTP status code for 'Length Required' */
public static final int code = 411;

/** Create a 'Length Required' HTTP Response. */
public LengthRequired() {
super(411,"Length Required");
}

/** Create a 'Length Required' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public LengthRequired(Throwable t) {
super(411,"Length Required", t);
}

/** Create a 'Length Required' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public LengthRequired(String m) {
super(411,"Length Required", m);
}

/** Create a 'Length Required' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public LengthRequired(String m, Throwable t) {
super(411,"Length Required", m, t);
}

}
