package tech.greenfield.vertx.irked.status;

import java.util.TreeMap;
import java.util.Map;
import tech.greenfield.vertx.irked.HttpError;
import java.lang.reflect.InvocationTargetException;
public class HttpStatuses {

public static Map<Integer, Class<? extends HttpError>> HTTP_STATUS_CODES = new TreeMap<Integer, Class<? extends HttpError>>();
static {
HTTP_STATUS_CODES.put(100,tech.greenfield.vertx.irked.status.Continue.class);
HTTP_STATUS_CODES.put(101,tech.greenfield.vertx.irked.status.SwitchingProtocols.class);
HTTP_STATUS_CODES.put(102,tech.greenfield.vertx.irked.status.Processing.class);
HTTP_STATUS_CODES.put(200,tech.greenfield.vertx.irked.status.OK.class);
HTTP_STATUS_CODES.put(201,tech.greenfield.vertx.irked.status.Created.class);
HTTP_STATUS_CODES.put(202,tech.greenfield.vertx.irked.status.Accepted.class);
HTTP_STATUS_CODES.put(203,tech.greenfield.vertx.irked.status.NonAuthoritativeInformation.class);
HTTP_STATUS_CODES.put(204,tech.greenfield.vertx.irked.status.NoContent.class);
HTTP_STATUS_CODES.put(205,tech.greenfield.vertx.irked.status.ResetContent.class);
HTTP_STATUS_CODES.put(206,tech.greenfield.vertx.irked.status.PartialContent.class);
HTTP_STATUS_CODES.put(207,tech.greenfield.vertx.irked.status.MultiStatus.class);
HTTP_STATUS_CODES.put(226,tech.greenfield.vertx.irked.status.IMUsed.class);
HTTP_STATUS_CODES.put(300,tech.greenfield.vertx.irked.status.MultipleChoices.class);
HTTP_STATUS_CODES.put(301,tech.greenfield.vertx.irked.status.MovedPermanently.class);
HTTP_STATUS_CODES.put(302,tech.greenfield.vertx.irked.status.Found.class);
HTTP_STATUS_CODES.put(303,tech.greenfield.vertx.irked.status.SeeOther.class);
HTTP_STATUS_CODES.put(304,tech.greenfield.vertx.irked.status.NotModified.class);
HTTP_STATUS_CODES.put(305,tech.greenfield.vertx.irked.status.UseProxy.class);
HTTP_STATUS_CODES.put(307,tech.greenfield.vertx.irked.status.TemporaryRedirect.class);
HTTP_STATUS_CODES.put(308,tech.greenfield.vertx.irked.status.PermanentRedirect.class);
HTTP_STATUS_CODES.put(400,tech.greenfield.vertx.irked.status.BadRequest.class);
HTTP_STATUS_CODES.put(401,tech.greenfield.vertx.irked.status.Unauthorized.class);
HTTP_STATUS_CODES.put(402,tech.greenfield.vertx.irked.status.PaymentRequired.class);
HTTP_STATUS_CODES.put(403,tech.greenfield.vertx.irked.status.Forbidden.class);
HTTP_STATUS_CODES.put(404,tech.greenfield.vertx.irked.status.NotFound.class);
HTTP_STATUS_CODES.put(405,tech.greenfield.vertx.irked.status.MethodNotAllowed.class);
HTTP_STATUS_CODES.put(406,tech.greenfield.vertx.irked.status.NotAcceptable.class);
HTTP_STATUS_CODES.put(407,tech.greenfield.vertx.irked.status.ProxyAuthenticationRequired.class);
HTTP_STATUS_CODES.put(408,tech.greenfield.vertx.irked.status.RequestTimeout.class);
HTTP_STATUS_CODES.put(409,tech.greenfield.vertx.irked.status.Conflict.class);
HTTP_STATUS_CODES.put(410,tech.greenfield.vertx.irked.status.Gone.class);
HTTP_STATUS_CODES.put(411,tech.greenfield.vertx.irked.status.LengthRequired.class);
HTTP_STATUS_CODES.put(412,tech.greenfield.vertx.irked.status.PreconditionFailed.class);
HTTP_STATUS_CODES.put(413,tech.greenfield.vertx.irked.status.PayloadTooLarge.class);
HTTP_STATUS_CODES.put(414,tech.greenfield.vertx.irked.status.URITooLong.class);
HTTP_STATUS_CODES.put(415,tech.greenfield.vertx.irked.status.UnsupportedMediaType.class);
HTTP_STATUS_CODES.put(416,tech.greenfield.vertx.irked.status.RangeNotSatisfiable.class);
HTTP_STATUS_CODES.put(417,tech.greenfield.vertx.irked.status.ExpectationFailed.class);
HTTP_STATUS_CODES.put(418,tech.greenfield.vertx.irked.status.Imateapot.class);
HTTP_STATUS_CODES.put(422,tech.greenfield.vertx.irked.status.UnprocessableEntity.class);
HTTP_STATUS_CODES.put(423,tech.greenfield.vertx.irked.status.Locked.class);
HTTP_STATUS_CODES.put(424,tech.greenfield.vertx.irked.status.FailedDependency.class);
HTTP_STATUS_CODES.put(426,tech.greenfield.vertx.irked.status.UpgradeRequired.class);
HTTP_STATUS_CODES.put(428,tech.greenfield.vertx.irked.status.PreconditionRequired.class);
HTTP_STATUS_CODES.put(429,tech.greenfield.vertx.irked.status.TooManyRequests.class);
HTTP_STATUS_CODES.put(431,tech.greenfield.vertx.irked.status.RequestHeaderFieldsTooLarge.class);
HTTP_STATUS_CODES.put(451,tech.greenfield.vertx.irked.status.UnavailableForLegalReasons.class);
HTTP_STATUS_CODES.put(500,tech.greenfield.vertx.irked.status.InternalServerError.class);
HTTP_STATUS_CODES.put(501,tech.greenfield.vertx.irked.status.NotImplemented.class);
HTTP_STATUS_CODES.put(502,tech.greenfield.vertx.irked.status.BadGateway.class);
HTTP_STATUS_CODES.put(503,tech.greenfield.vertx.irked.status.ServiceUnavailable.class);
HTTP_STATUS_CODES.put(504,tech.greenfield.vertx.irked.status.GatewayTimeout.class);
HTTP_STATUS_CODES.put(505,tech.greenfield.vertx.irked.status.HTTPVersionNotSupported.class);
HTTP_STATUS_CODES.put(506,tech.greenfield.vertx.irked.status.VariantAlsoNegotiates.class);
HTTP_STATUS_CODES.put(507,tech.greenfield.vertx.irked.status.InsufficientStorage.class);
HTTP_STATUS_CODES.put(511,tech.greenfield.vertx.irked.status.NetworkAuthenticationRequired.class);
};
public static HttpError create(int statusCode) throws InstantiationException {
try {
return HTTP_STATUS_CODES.get(statusCode).getConstructor().newInstance();
} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException
	| NoSuchMethodException | SecurityException e) {
throw new InstantiationException(e.toString());
}
}
}
