package tech.greenfield.vertx.irked.status;

import tech.greenfield.vertx.irked.HttpError;

/**
 * HTTP Status Code for HTTP Version Not Supported
 * To send this in the response, either pass an instance (with optional custom message) to 
 * {@link tech.greenfield.vertx.irked.Request#send(HttpError)} or throw it out of an Irked controller handler.
 * To throw this response out of a functional interface implementation (lambda) that does not
 * declare throwing {@link HttpError}, use the {@link #unchecked()} method. 
 */
public class HTTPVersionNotSupported extends HttpError {

private static final long serialVersionUID = 6010479119788061049L;

/** HTTP status code for 'HTTP Version Not Supported' */
public static final int code = 505;

/** Create a 'HTTP Version Not Supported' HTTP Response. */
public HTTPVersionNotSupported() {
super(505,"HTTP Version Not Supported");
}

/** Create a 'HTTP Version Not Supported' HTTP Response with an underlying cause.
 * @param t underlying cause
 **/
public HTTPVersionNotSupported(Throwable t) {
super(505,"HTTP Version Not Supported", t);
}

/** Create a 'HTTP Version Not Supported' HTTP Response with a custom message in the body.
 * @param m custom response message
 **/
public HTTPVersionNotSupported(String m) {
super(505,"HTTP Version Not Supported", m);
}

/** Create a 'HTTP Version Not Supported' HTTP Response with a custom message in the body and an underlying cause.
 * @param m custom response message
 * @param t underlying cause
 **/
public HTTPVersionNotSupported(String m, Throwable t) {
super(505,"HTTP Version Not Supported", m, t);
}

}
